% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.capr}
\alias{print.capr}
\title{Print method for CAP regression fits}
\usage{
\method{print}{capr}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{An object of class \code{capr}, typically the result of \code{\link[=capr]{capr()}}.}

\item{digits}{Number of significant digits to show when printing numeric
values.}

\item{...}{Additional arguments passed on to \code{\link[=print.data.frame]{print.data.frame()}}.}
}
\value{
The input object \code{x}, invisibly.
}
\description{
Formats the coefficient matrix \eqn{\hat{B}} returned by \code{\link[=capr]{capr()}} in a
linear-regression style table, showing the estimate for each predictor and
component.
}
\examples{
simu.data <- simu.capr(seed = 123L, n = 120L)
K <- 2L
fit <- capr(
    S = simu.data$S,
    X = simu.data$X,
    K = K
)
print(fit)
}
