% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simu.R
\name{simu.capr}
\alias{simu.capr}
\title{Simulate covariance matrices compatible with \code{capr()}}
\usage{
simu.capr(seed = 123L, n = 120L)
}
\arguments{
\item{seed}{Integer seed used for reproducibility.}

\item{n}{Number of observations (slices) to generate.}
}
\value{
A list with components:
\item{S}{Array of dimension \eqn{p \times p \times n} holding the simulated
covariance matrices.}
\item{X}{Design matrix of size \eqn{n \times 2} with an intercept and a
Bernoulli covariate.}
\item{Q}{Orthogonal matrix whose columns are the latent directions.}
\item{BetaMat}{True coefficient matrix used to form the eigenvalues.}
\item{H}{Average covariance matrix \eqn{\frac{1}{n}\sum_i S_i}.}
\item{p, n}{The dimension and sample size supplied to the generator.}
}
\description{
Generates a simple synthetic dataset for CAP regression consisting of a
covariance cube, design matrix, and the latent orthogonal directions used to
build the covariance slices.
}
\examples{
sim <- simu.capr(seed = 10, n = 50)
str(sim$S)

}
