% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format-caugi.R
\name{caugi_serialize}
\alias{caugi_serialize}
\title{Serialize caugi Graph to JSON String}
\usage{
caugi_serialize(x, comment = NULL, tags = NULL)
}
\arguments{
\item{x}{A \code{caugi} object or an object coercible to \code{caugi}.}

\item{comment}{Optional character string with a comment about the graph.}

\item{tags}{Optional character vector of tags for categorizing the graph.}
}
\value{
A character string containing the JSON representation.
}
\description{
Converts a caugi graph to a JSON string in the native caugi format.
This is a lower-level function; consider using \code{write_caugi()} for
writing to files.
}
\examples{
cg <- caugi(A \%-->\% B, class = "DAG")
json <- caugi_serialize(cg)
cat(json)

}
\seealso{
Other export: 
\code{\link{caugi_deserialize}()},
\code{\link{caugi_dot}()},
\code{\link{caugi_export}()},
\code{\link{caugi_graphml}()},
\code{\link{caugi_mermaid}()},
\code{\link{export-classes}},
\code{\link{format-caugi}},
\code{\link{format-dot}},
\code{\link{format-graphml}},
\code{\link{format-mermaid}},
\code{\link{knit_print.caugi_export}},
\code{\link{read_caugi}()},
\code{\link{read_graphml}()},
\code{\link{to_dot}()},
\code{\link{to_graphml}()},
\code{\link{to_mermaid}()},
\code{\link{write_caugi}()},
\code{\link{write_dot}()},
\code{\link{write_graphml}()},
\code{\link{write_mermaid}()}
}
\concept{export}
