% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cos_similarity.R
\name{rank_angle}
\alias{rank_angle}
\title{Rank distance angles from a cosine similarity matrix}
\usage{
rank_angle(x, angle_cutoff = 45)
}
\arguments{
\item{x}{a cosine similarity matrix generated by \code{\link[=cos_similarity]{cos_similarity()}}.}

\item{angle_cutoff}{Cutoff angle in degrees below which to subset the dataframe.}
}
\value{
a dataframe of rows and columns as factors and the angle between
that row and column extracted from the cosine similarity matrix. Row and
column location are stored as factors so that they can be converted back to
coordinates in the similarity matrix easily using \code{as.integer()}.
}
\description{
Converts a cosine similarity matrix to angular distance. Then orders the
elements in increasing angle. Elements below \code{angle_cutoff} are returned in a
dataframe.
}
