% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{dataset_info}
\alias{dataset_info}
\title{Inspect a Clinical Trial Dataset Without Downloading}
\usage{
dataset_info(source, repo = "Lovemore-Gakava/clinTrialData")
}
\arguments{
\item{source}{Character string. Name of the study (e.g.
\code{"cdisc_pilot_extended"}). Use \code{\link[=list_available_studies]{list_available_studies()}} to see all
options.}

\item{repo}{GitHub repository in the form \code{"owner/repo"}. Defaults to the
official \code{clinTrialData} release repository.}
}
\value{
Invisibly returns the metadata as a named list.
}
\description{
Fetches and displays metadata for any study available in the
\code{clinTrialData} library -- without downloading the full dataset. Metadata
includes the study description, available domains and datasets, subject
count, version, and data source attribution.

For studies already downloaded via \code{\link[=download_study]{download_study()}}, the metadata is read
from the local cache and works offline. For studies not yet downloaded, a
small JSON file (~2KB) is fetched from the GitHub Release.
}
\examples{
\donttest{
dataset_info("cdisc_pilot")
}
}
