% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{list_available_studies}
\alias{list_available_studies}
\title{List Studies Available for Download}
\usage{
list_available_studies(repo = "Lovemore-Gakava/clinTrialData")
}
\arguments{
\item{repo}{GitHub repository in the form \code{"owner/repo"}. Defaults to the
official \code{clinTrialData} release repository.}
}
\value{
A data frame with columns:
\describe{
\item{source}{Study name (pass this to \code{\link[=download_study]{download_study()}} or
\code{\link[=connect_clinical_data]{connect_clinical_data()}})}
\item{version}{Release tag the asset belongs to}
\item{size_mb}{Asset size in megabytes}
\item{cached}{\code{TRUE} if the study is already in the local cache}
}
}
\description{
Returns a data frame of all clinical trial studies available as GitHub
Release assets, along with their local cache status. Studies marked as
\code{cached = TRUE} are already downloaded and available for use with
\code{\link[=connect_clinical_data]{connect_clinical_data()}} without an internet connection.

When GitHub is unreachable, the function falls back to the last
successfully fetched listing (if available) and issues a warning.
The \code{cached} column is always recomputed from the local filesystem.

Requires the \code{piggyback} package.
}
\examples{
\donttest{
list_available_studies()
}
}
