% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_roc.R
\name{calc_cindex}
\alias{calc_cindex}
\title{Calculate C-index for survival data}
\usage{
calc_cindex(data, time_var, event_var, marker_var)
}
\arguments{
\item{data}{A data frame containing the survival time, event indicator, and marker variable.}

\item{time_var}{A string specifying the name of the survival time variable in the data frame.}

\item{event_var}{A string specifying the name of the event indicator variable in the data frame.}

\item{marker_var}{A string specifying the name of the marker variable in the data frame.}
}
\value{
The C-index value.
}
\description{
Calculate C-index for survival data. It's a wrapper function for \code{Hmisc::rcorr.cens()}.
}
\examples{
# Calculate C-index using lung dataset from survival package
data(cancer, package = "survival")
# Use age as the marker variable
calc_cindex(lung, "time", "status", "age")
}
