% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_files.R
\name{combine_files}
\alias{combine_files}
\title{combine multiple data files into a single data frame}
\usage{
combine_files(
  path = ".",
  pattern = NULL,
  add_file_name = FALSE,
  unique_only = TRUE,
  reader_fun = read.csv,
  ...
)
}
\arguments{
\item{path}{A string as the path to find the data files.}

\item{pattern}{A file pattern to filter the required data files.}

\item{add_file_name}{A logical value to indicate whether to add the file name as a column. Note that
the added file name will affect the uniqueness of the data.}

\item{unique_only}{A logical value to indicate whether to remove the duplicated rows.}

\item{reader_fun}{A function to read the data files. Can be \code{read.csv}, \code{openxlsx::read.xlsx}, etc.}

\item{...}{Other parameters passed to the \code{reader_fun}.}
}
\value{
A data frame. If no data files found, return \code{NULL}.
}
\description{
combine multiple data files into a single data frame
}
\examples{
library(withr)
with_tempdir({
  write.csv(data.frame(x = 1:3, y = 4:6), "file1.csv", row.names = FALSE)
  write.csv(data.frame(x = 7:9, y = 10:12), "file2.csv", row.names = FALSE)
  dat <- combine_files(pattern = "file")
})
print(dat)
}
