% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-parse.R
\name{aggregate_duplicate_edges}
\alias{aggregate_duplicate_edges}
\title{Aggregate Duplicate Edges}
\usage{
aggregate_duplicate_edges(edges, method = "mean")
}
\arguments{
\item{edges}{Data frame with \code{from}, \code{to}, and \code{weight} columns.}

\item{method}{Aggregation method: \code{"sum"} (default), \code{"mean"},
\code{"max"}, \code{"min"}, \code{"first"}, or a custom function that
takes a numeric vector and returns a single value.}
}
\value{
A deduplicated data frame with the same columns as the input, where
each node pair appears only once with its aggregated weight.
}
\description{
Combines duplicate edges by aggregating their weights using a specified
function (sum, mean, max, min, or first).
}
\details{
\subsection{Aggregation Methods}{

\describe{
\item{\strong{sum}}{Total weight of all duplicate edges. Useful for frequency
counts or when edges represent additive quantities (e.g., number of emails).}
\item{\strong{mean}}{Average weight. Useful for averaging multiple measurements
or when duplicates represent repeated observations.}
\item{\strong{max}}{Maximum weight. Useful for finding the strongest connection
or most recent value.
}
\item{\strong{min}}{Minimum weight. Useful for the most conservative estimate
or earliest value.}
\item{\strong{first}}{Keep first occurrence. Useful for preserving original
order or when duplicates are erroneous.}
}

The output edge list uses canonical node ordering (lower index first for
undirected networks), ensuring consistent from/to assignment.
}
}
\seealso{
\code{\link{detect_duplicate_edges}} for identifying duplicates before
aggregation
}
\keyword{internal}
