% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cograph.R
\name{cograph}
\alias{cograph}
\title{Create a Network Visualization}
\usage{
cograph(
  input,
  layout = "spring",
  directed = NULL,
  node_labels = NULL,
  seed = 42,
  ...
)
}
\arguments{
\item{input}{Network input. Can be:
\itemize{
\item A square numeric matrix (adjacency/weight matrix)
\item A data frame with edge list (from, to, optional weight columns)
\item An igraph object
\item A statnet network object
\item A qgraph object
\item A tna object
}}

\item{layout}{Layout algorithm: "circle", "spring", "groups", "grid",
"random", "star", "bipartite", or "custom". Default "spring".}

\item{directed}{Logical. Force directed interpretation. NULL for auto-detect.}

\item{node_labels}{Character vector of node labels.}

\item{seed}{Random seed for deterministic layouts. Default 42. Set NULL for random.}

\item{...}{Additional arguments passed to the layout function.}
}
\value{
A cograph_network object that can be further customized and rendered.
}
\description{
The main entry point for cograph. Accepts adjacency matrices, edge lists,
igraph, statnet network, qgraph, or tna objects and creates a visualization-ready
network object.
}
\examples{
# From adjacency matrix
adj <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
cograph(adj)

# From edge list
edges <- data.frame(from = c(1, 1, 2), to = c(2, 3, 3))
cograph(edges)

# With customization (pipe-friendly workflow)
adj <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
cograph(adj, layout = "circle") |>
  sn_nodes(fill = "steelblue") |>
  sn_edges(color = "gray50") |>
  splot()

# Weighted network with automatic styling
w_adj <- matrix(c(0, 0.5, -0.3, 0.5, 0, 0.4, -0.3, 0.4, 0), nrow = 3)
cograph(w_adj) |>
  sn_edges(color = "weight", width = "weight") |>
  splot()

# With igraph (if installed)
if (requireNamespace("igraph", quietly = TRUE)) {
  library(igraph)
  g <- make_ring(10)
  cograph(g) |> splot()
}
}
\seealso{
\code{\link{splot}} for base R graphics rendering,
\code{\link{soplot}} for grid graphics rendering,
\code{\link{sn_nodes}} for node customization,
\code{\link{sn_edges}} for edge customization,
\code{\link{sn_layout}} for changing layouts,
\code{\link{sn_theme}} for visual themes,
\code{\link{sn_palette}} for color palettes,
\code{\link{from_qgraph}} and \code{\link{from_tna}} for converting external objects
}
