% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale-constants.R
\name{compute_adaptive_esize}
\alias{compute_adaptive_esize}
\title{Compute Adaptive Base Edge Size}
\usage{
compute_adaptive_esize(n_nodes, directed = FALSE)
}
\arguments{
\item{n_nodes}{Number of nodes in the network.}

\item{directed}{Whether the network is directed (directed networks use thinner edges).}
}
\value{
Numeric maximum edge width (suitable for lwd parameter).
}
\description{
Calculates the maximum edge width that decreases with more nodes.
Inspired by qgraph but scaled for line widths (not pixels).
}
\details{
The formula produces reasonable line widths:
\itemize{
\item 3 nodes: ~5
\item 10 nodes: ~4.5
\item 50 nodes: ~3
\item 100 nodes: ~2
\item 200 nodes: ~1.2
}

For directed networks, the size is reduced by 30\% (minimum 1).
}
\keyword{internal}
