% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splot-edges.R
\name{get_edge_label_position}
\alias{get_edge_label_position}
\title{Get Label Position on Edge}
\usage{
get_edge_label_position(
  x1,
  y1,
  x2,
  y2,
  position = 0.5,
  curve = 0,
  curvePivot = 0.5,
  label_offset = 0
)
}
\arguments{
\item{x1, y1}{Start point.}

\item{x2, y2}{End point.}

\item{position}{Position along edge (0-1).}

\item{curve}{Curvature amount.}

\item{curvePivot}{Curve pivot position.}

\item{label_offset}{Additional perpendicular offset for the label (in user coords).
Positive values offset in the same direction as the curve bulge.
Default 0.03 provides good separation from the edge line.}
}
\value{
List with x, y coordinates.
}
\description{
Calculates the position for an edge label (matches qgraph-style curves).
For curved edges, the label is offset perpendicular to the edge to avoid
overlapping with the edge line.
}
\keyword{internal}
