% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-gephi-fr.R
\name{layout_gephi_fr}
\alias{layout_gephi_fr}
\title{Gephi Fruchterman-Reingold Layout}
\usage{
layout_gephi_fr(g, area = 10000, gravity = 10, speed = 1, niter = 100)
}
\arguments{
\item{g}{An igraph graph object.}

\item{area}{Area parameter controlling node spread. Default 10000.}

\item{gravity}{Gravity force pulling nodes toward center. Default 10.0.}

\item{speed}{Speed/cooling parameter. Default 1.0.}

\item{niter}{Number of iterations. Default 100.}
}
\value{
A matrix with x,y coordinates for each node.
}
\description{
Force-directed layout that replicates Gephi's Fruchterman-Reingold algorithm.
This is a strict port of the Java implementation from Gephi's source code.
}
\details{
This layout is a direct port of Gephi's ForceAtlas algorithm variant of
Fruchterman-Reingold. Key differences from igraph's layout_with_fr:
\itemize{
\item Uses Gephi's specific constants (SPEED_DIVISOR=800, AREA_MULTIPLICATOR=10000)
\item Includes configurable gravity toward center
\item Different cooling/speed mechanism
}
}
\keyword{internal}
