% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tplot.R
\name{plot_tna}
\alias{plot_tna}
\alias{tplot}
\title{TNA-Style Network Plot (qgraph Compatible)}
\usage{
plot_tna(
  x,
  color = NULL,
  labels = NULL,
  layout = "oval",
  theme = "colorblind",
  mar = c(0.1, 0.1, 0.1, 0.1),
  cut = NULL,
  edge.labels = TRUE,
  edge.label.position = 0.7,
  edge.label.cex = 0.6,
  edge.color = "#003355",
  vsize = 7,
  pie = NULL,
  pieColor = NULL,
  lty = NULL,
  directed = NULL,
  minimum = NULL,
  posCol = NULL,
  negCol = NULL,
  arrowAngle = NULL,
  title = NULL,
  ...
)

tplot(
  x,
  color = NULL,
  labels = NULL,
  layout = "oval",
  theme = "colorblind",
  mar = c(0.1, 0.1, 0.1, 0.1),
  cut = NULL,
  edge.labels = TRUE,
  edge.label.position = 0.7,
  edge.label.cex = 0.6,
  edge.color = "#003355",
  vsize = 7,
  pie = NULL,
  pieColor = NULL,
  lty = NULL,
  directed = NULL,
  minimum = NULL,
  posCol = NULL,
  negCol = NULL,
  arrowAngle = NULL,
  title = NULL,
  ...
)
}
\arguments{
\item{x}{A weight matrix (adjacency matrix) or tna object}

\item{color}{Node fill colors}

\item{labels}{Node labels}

\item{layout}{Layout: "circle", "spring", "oval", or a coordinate matrix}

\item{theme}{Plot theme ("colorblind", "gray", etc.)}

\item{mar}{Plot margins (numeric vector of length 4)}

\item{cut}{Edge emphasis threshold}

\item{edge.labels}{Show edge weight labels}

\item{edge.label.position}{Position of edge labels along edge (0-1)}

\item{edge.label.cex}{Edge label size multiplier}

\item{edge.color}{Edge colors}

\item{vsize}{Node size}

\item{pie}{Pie/donut fill values (e.g., initial probabilities)}

\item{pieColor}{Pie/donut segment colors}

\item{lty}{Line type for edges (1=solid, 2=dashed, 3=dotted)}

\item{directed}{Logical, is the graph directed?}

\item{minimum}{Minimum edge weight to display}

\item{posCol}{Color for positive edges}

\item{negCol}{Color for negative edges}

\item{arrowAngle}{Arrow head angle in radians. Default pi/6 (30 degrees).}

\item{title}{Plot title}

\item{...}{Additional arguments passed to splot()}
}
\value{
Invisibly returns the cograph_network object from splot().
}
\description{
A drop-in replacement for qgraph::qgraph() that uses cograph's splot engine.
Accepts qgraph parameter names for seamless migration from qgraph to cograph.
}
\examples{
# Simple usage
m <- matrix(runif(25), 5, 5)
plot_tna(m)

# With qgraph-style parameters
plot_tna(m, vsize = 15, edge.label.cex = 2, layout = "circle")

# With custom colors
plot_tna(m, color = rainbow(5), vsize = 10)

}
