% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output-save.R
\name{sn_save_ggplot}
\alias{sn_save_ggplot}
\title{Save as ggplot2}
\usage{
sn_save_ggplot(
  network,
  filename,
  width = 7,
  height = 7,
  dpi = 300,
  title = NULL,
  ...
)
}
\arguments{
\item{network}{A cograph_network object.}

\item{filename}{Output filename.}

\item{width}{Width in inches.}

\item{height}{Height in inches.}

\item{dpi}{Resolution for raster formats.}

\item{title}{Optional plot title.}

\item{...}{Additional arguments passed to ggsave.}
}
\value{
Invisible filename.
}
\description{
Save network as a ggplot2 object to file using ggsave.
}
\examples{
\donttest{
adj <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)
net <- cograph(adj)
sn_save_ggplot(net, file.path(tempdir(), "network.pdf"))
}
}
