% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cograph.R
\name{sn_theme}
\alias{sn_theme}
\title{Apply Theme to Network}
\usage{
sn_theme(network, theme, ...)
}
\arguments{
\item{network}{A cograph_network object, matrix, data.frame, or igraph object.
Matrices and other inputs are auto-converted.}

\item{theme}{Theme name (string) or CographTheme object.}

\item{...}{Additional theme parameters to override.}
}
\value{
Modified cograph_network object.
}
\description{
Apply a visual theme to the network.
}
\details{
\subsection{Available Themes}{

\describe{
\item{\strong{classic}}{Default theme with white background, blue nodes, gray edges.}
\item{\strong{dark}}{Dark background with light nodes. Good for presentations.}
\item{\strong{minimal}}{Subtle styling with thin edges and muted colors.}
\item{\strong{colorblind}}{Optimized for color vision deficiency.}
\item{\strong{grayscale}}{Black and white only.}
\item{\strong{vibrant}}{Bold, saturated colors.}
}

Use \code{list_themes()} to see all available themes.
}
}
\examples{
adj <- matrix(c(0, 1, 1, 1, 0, 1, 1, 1, 0), nrow = 3)

# Apply different themes
cograph(adj) |> sn_theme("dark") |> splot()
cograph(adj) |> sn_theme("minimal") |> splot()

# Override specific theme properties
cograph(adj) |> sn_theme("classic", background = "lightgray") |> splot()

# Direct matrix input
adj |> sn_theme("dark")
}
\seealso{
\code{\link{cograph}} for network creation,
\code{\link{sn_palette}} for color palettes,
\code{\link{sn_nodes}} for node customization,
\code{\link{sn_edges}} for edge customization,
\code{\link{list_themes}} to see available themes,
\code{\link{splot}} and \code{\link{soplot}} for plotting
}
