% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver_optim.R
\name{lbfgsb}
\alias{lbfgsb}
\title{L-BFGS-B Solver (Box Constrained)}
\usage{
lbfgsb(lower = -Inf, upper = Inf, max_iter = 100L, tol = 1e-08)
}
\arguments{
\item{lower}{Lower bounds on parameters (can be -Inf)}

\item{upper}{Upper bounds on parameters (can be Inf)}

\item{max_iter}{Maximum number of iterations}

\item{tol}{Convergence tolerance}
}
\value{
A solver function
}
\description{
Creates a solver using L-BFGS-B, a limited-memory BFGS variant that
supports box constraints (lower and upper bounds on parameters).
}
\details{
Unlike the constraint system in mle_problem (which uses projection),
L-BFGS-B handles box constraints natively within the algorithm.
Use this when you have simple bound constraints.
}
\examples{
\donttest{
set.seed(42)
x <- rnorm(50, 5, 2)
problem <- mle_problem(
  loglike = function(theta) sum(dnorm(x, theta[1], theta[2], log = TRUE))
)
# Positive sigma via box constraint
solver <- lbfgsb(lower = c(-Inf, 0.01), upper = c(Inf, Inf))
result <- solver(problem, c(4, 1.5))
}

}
