% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{mle_constraint}
\alias{mle_constraint}
\title{Create domain constraint specification}
\usage{
mle_constraint(support = function(theta) TRUE, project = function(theta) theta)
}
\arguments{
\item{support}{Function testing if theta is in support (returns TRUE/FALSE)}

\item{project}{Function projecting theta onto support}
}
\value{
An mle_constraint object
}
\description{
Specifies domain constraints for optimization. The support function
checks if parameters are valid, and the project function maps invalid
parameters back to valid ones.
}
\examples{
# Positive parameters only
constraint <- mle_constraint(
  support = function(theta) all(theta > 0),
  project = function(theta) pmax(theta, 1e-8)
)

# Parameters in [0, 1]
constraint <- mle_constraint(
  support = function(theta) all(theta >= 0 & theta <= 1),
  project = function(theta) pmax(0, pmin(1, theta))
)

# No constraints (default)
constraint <- mle_constraint()
}
