% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{styles_pv_split}
\alias{styles_pv_split}
\title{Present-value split between income and resale by style}
\usage{
styles_pv_split(
  styles,
  config_dir = system.file("extdata", package = "cre.dcf")
)
}
\arguments{
\item{styles}{Character vector of style identifiers.}

\item{config_dir}{Directory where preset YAML files are stored.}
}
\value{
A tibble with columns:
style, pv_income, pv_resale, share_pv_income, share_pv_resale.
}
\description{
For each style preset, this helper:
\itemize{
\item runs \code{\link[=run_case]{run_case()}} under the all-equity scenario,
\item takes the cash-flow table used for the unlevered DCF,
\item discounts positive cash inflows at the DCF discount rate,
\item decomposes the resulting present value into:
\itemize{
\item income  = free cash flow excluding resale proceeds,
\item resale  = terminal sale proceeds.
}
}
}
\details{
Year 0 (initial outlay) is excluded from the income/resale split so that
shares remain numerically stable and interpretable.
}
