% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{mean_predictor}
\alias{mean_predictor}
\alias{median_predictor}
\title{Aggregators for cross-fitted predictors}
\usage{
mean_predictor(fs)

median_predictor(fs)
}
\arguments{
\item{fs}{A list of prediction functions. Each function must accept
at least a \code{newdata} argument and return a numeric vector of
predictions of the same length as \code{nrow(newdata)}.}
}
\value{
A function of the form \code{function(newdata, ...)}, which
returns a numeric vector of predictions. If \code{fs} is empty, the
returned function always returns \code{numeric(0)}.
}
\description{
These helpers aggregate several cross-fitted predictors into a single
ensemble predictor. They are designed for methods run with
\code{mode = "predict"} in \code{\link{crossfit}} and
\code{\link{crossfit_multi}}.
}
\examples{
# Two simple prediction functions of x
f1 <- function(newdata, ...) newdata$x
f2 <- function(newdata, ...) 2 * newdata$x

ens_mean   <- mean_predictor(list(f1, f2))

newdata <- data.frame(x = 1:5)
ens_mean(newdata)
# Two simple prediction functions of x
f1 <- function(newdata, ...) newdata$x
f2 <- function(newdata, ...) 2 * newdata$x

ens_median <- median_predictor(list(f1, f2))

newdata <- data.frame(x = 1:5)
ens_median(newdata)
}
