% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_crt2_design.R
\name{run_crt2_design}
\alias{run_crt2_design}
\title{Find study design output specifications based on all five CRT co-primary design methods.}
\usage{
run_crt2_design(
  output,
  power = NA,
  K = NA,
  m = NA,
  alpha = 0.05,
  beta1,
  beta2,
  varY1,
  varY2,
  rho01,
  rho02,
  rho1,
  rho2,
  r = 1
)
}
\arguments{
\item{output}{Parameter to calculate, either "power", "K", or "m"; character.}

\item{power}{Desired statistical power; numeric.}

\item{K}{Number of clusters in each arm; numeric.}

\item{m}{Individuals per cluster; numeric.}

\item{alpha}{Type I error rate; numeric.}

\item{beta1}{Effect size for the first outcome; numeric.}

\item{beta2}{Effect size for the second outcome; numeric.}

\item{varY1}{Total variance for the first outcome; numeric.}

\item{varY2}{Total variance for the second outcome; numeric.}

\item{rho01}{Correlation of the first outcome for two different individuals in the same cluster; numeric.}

\item{rho02}{Correlation of the second outcome for two different individuals in the same cluster; numeric.}

\item{rho1}{Correlation between the first and second outcomes for two individuals in the same cluster; numeric.}

\item{rho2}{Correlation between the first and second outcomes for the same individual; numeric.}

\item{r}{Treatment allocation ratio - K2 = rK1 where K1 is number of clusters in experimental group; numeric.}
}
\value{
A data frame of numerical values.
}
\description{
Allows user to calculate either statistical power, number of clusters per treatment group (K), or cluster size (m), given a set of input values for all five study design approaches.
}
\examples{
run_crt2_design(output = "power", K = 15, m = 300, alpha = 0.05,
beta1 = 0.1, beta2 = 0.1, varY1 = 0.23, varY2 = 0.25,
rho01 = 0.025, rho02 = 0.025, rho1 = 0.01, rho2  = 0.05)
}
