% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clu_hclust.R
\name{cluster_hclust}
\alias{cluster_hclust}
\title{Hierarchical clustering}
\usage{
cluster_hclust(
  k = 2,
  h = NULL,
  method = "ward.D2",
  dist = "euclidean",
  scale = TRUE
)
}
\arguments{
\item{k}{number of clusters to cut the tree (default 2)}

\item{h}{height to cut the tree (optional; if provided, overrides \code{k})}

\item{method}{linkage method passed to \code{stats::hclust} (default "ward.D2")}

\item{dist}{distance method passed to \code{stats::dist} (default "euclidean")}

\item{scale}{logical; whether to scale data before distance (default TRUE)}
}
\value{
returns a hierarchical clustering object.
}
\description{
Agglomerative hierarchical clustering using \code{stats::hclust}.
}
\details{
Computes a distance matrix (optionally after scaling) and builds a dendrogram. Clusters are
obtained by cutting the tree with \code{k} (number of clusters) or \code{h} (height).
}
\examples{
data(iris)
model <- cluster_hclust(k = 3)
model <- fit(model, iris[,1:4])
clu <- cluster(model, iris[,1:4])
table(clu)
}
\references{
Johnson, S. C. (1967). Hierarchical clustering schemes. Psychometrika.
}
