% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_sample_simple.R
\name{sample_simple}
\alias{sample_simple}
\title{Simple sampling}
\usage{
sample_simple(size, replace = FALSE, prob = NULL, seed = NULL)
}
\arguments{
\item{size}{number of samples to draw}

\item{replace}{logical; sample with replacement if TRUE}

\item{prob}{optional vector of sampling probabilities}

\item{seed}{optional random seed for reproducibility}
}
\value{
returns an object of class \code{sample_simple}
}
\description{
Sample rows or elements with or without replacement.
}
\examples{
data(iris)
srswor <- sample_simple(size = 10, replace = FALSE, seed = 123)
srswr <- sample_simple(size = 10, replace = TRUE, seed = 123)
sample_wor <- transform(srswor, iris$Sepal.Length)
sample_wr <- transform(srswr, iris$Sepal.Length)
sample_wor
sample_wr
}
