% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-filter.R
\name{filter.tbl_lazy}
\alias{filter.tbl_lazy}
\title{Subset rows using column values}
\usage{
\method{filter}{tbl_lazy}(.data, ..., .by = NULL, .preserve = FALSE)
}
\arguments{
\item{.data}{A lazy data frame backed by a database query.}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables, or
functions of variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending
order.}

\item{.by}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> Optionally, a selection of columns to
group by for just this operation, functioning as an alternative to \code{\link[dplyr:group_by]{group_by()}}. For
details and examples, see \link[dplyr:dplyr_by]{?dplyr_by}.}

\item{.preserve}{Not supported by this method.}
}
\value{
Another \code{tbl_lazy}. Use \code{\link[dplyr:explain]{dplyr::show_query()}} to see the generated
query, and use \code{\link[=collect.tbl_sql]{collect()}} to execute the query
and return data to R.
}
\description{
This is a method for the dplyr \code{\link[dplyr:filter]{dplyr::filter()}} generic. It generates the
\code{WHERE} clause of the SQL query.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(x = c(2, NA, 5, NA, 10), y = 1:5)
db \%>\% filter(x < 5) \%>\% show_query()
db \%>\% filter(is.na(x)) \%>\% show_query()
}
