% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybridIndex.r
\name{hybridIndex}
\alias{hybridIndex}
\title{Compute hybrid index from genotypes, files, or numeric values}
\usage{
hybridIndex(
  x,
  ChosenInds = "all",
  rescale = FALSE,
  ploidy = NULL,
  ChosenSites = "all",
  changePolarity = NULL
)
}
\arguments{
\item{x}{Either a genotype matrix/data.frame, a path to a text file
containing hybrid indices, one or more genotype files in diem format,
or a numeric vector of hybrid index values.}

\item{ChosenInds}{A numeric or logical vector of indices of individuals to be included
in the analysis.}

\item{rescale}{Logical, whether to linearly rescale the resulting hybrid
indices to the interval 0–1. Defaults to \code{FALSE}.}

\item{ploidy}{A logical or a list of length equal to length of \code{files}. Each
element of the list
contains a numeric vector with ploidy numbers for all individuals specified in
the \code{files}.}

\item{ChosenSites}{A logical vector indicating which sites are to be included in the
analysis.}

\item{changePolarity}{A logical vector or a list of logical vectors with length equal
to the number of markers.}
}
\value{
A numeric vector of hybrid index values. Names are not preserved.
}
\description{
Provides a unified way to obtain the hybrid index regardless of input format.
The function accepts:
\itemize{
\item a genotype matrix or data frame (ideally polarised);
\item a 4-column numeric matrix in the I4 format (summaries of genotype counts);
\item a file containing hybrid index values produced by \code{diem};
\item one or more genotype files in diem format together with ploidy information;
\item or a numeric vector of hybrid index values.
}
}
\details{
The function returns a numeric vector of hybrid indices and can optionally
subset individuals or rescale the values to the interval 0-1.

Input type is detected automatically:
\itemize{
\item \strong{Hybrid-index file} - the last column is extracted. The file may optionally
contain the header \code{"HybridIndex"}. No filtering is applied unless
\code{ChosenInds} is specified.
\item \strong{Numeric vector} - values are returned unchanged (except optional
subsetting and rescaling).
\item \strong{I4 matrix} - a 4-column numeric matrix where each row contains
genotype summary counts. Each row is processed directly by
\code{pHetErrOnStateCount(row)}.
\item \strong{Genotype matrix} - typically polarised genotypes from \code{importPolarized}.
Each row is converted to state counts via \code{sStateCount()} and then passed to
\code{pHetErrOnStateCount()}.
\item \strong{Ploidy-aware multi-file input} - if \code{x} is a character vector of files
and \code{ploidy} and \code{changePolarity} are supplied, ploidy-aware hybrid indices
are calculated for an optional subset of individuals (\code{ChosenInds}) and
sites (\code{ChosenSites}). Note that if the filename in \code{x} is not supplied together
with \code{ploidy} and \code{changePolarity} arguments, the function assumes the file contains
hybrid indices such as those saved by \code{diem()} to \emph{HIwithOptimalPolarities.txt}.
}

If \code{rescale = TRUE}, the hybrid index is mapped to \eqn{[0,1]}. If all values
are equal or non-finite, the original scale is preserved and a warning issued.

Missing values are replaced with \code{0.5}, reflecting the default hybrid index
for samples with no usable genotype information.
}
\examples{
hybridIndex(c(0.3, 0.5, 0.7))
hybridIndex(c(0.3, 0.5, 0.7), rescale = TRUE)

hybridIndex(1:10, ChosenInds = 1:5, rescale = TRUE)

filepaths <- c(
  system.file("extdata", "data7x3.txt", package = "diemr"),
  system.file("extdata", "data7x10.txt", package = "diemr")
)

ploidies <- list(
  rep(2, 7),
  c(2, 1, 2, 2, 2, 1, 2)
)

hybridIndex(x = filepaths, ploidy = ploidies, 
  changePolarity = c(FALSE, TRUE, TRUE, TRUE, TRUE, TRUE, TRUE, FALSE, 
                     TRUE, TRUE, FALSE, TRUE, TRUE))

}
\seealso{
\link{pHetErrOnStateCount}, \link{sStateCount}, \link{importPolarized}
}
