% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ActiveIngredient.R
\name{dpd_active_ingredient}
\alias{dpd_active_ingredient}
\title{Active Ingredient}
\usage{
dpd_active_ingredient(id, name, lang = c("en", "fr"))
}
\arguments{
\item{id}{Drug product code.}

\item{name}{Ingredient name.}

\item{lang}{Language of the response. One of \code{"en"} or \code{"fr"} for English or
French, respectively.}
}
\value{
A \code{tibble} with columns:
\itemize{
\item \code{dosage_unit}: Active ingredient dosage unit.
\item \code{dosage_value}: Quantitative value of the active ingredient dosage.
\item \code{drug_code}: Code assigned to each drug product.
\item \code{ingredient_name}: Ingredient name.
\item \code{strength}: Quantitative value of the active ingredient strength.
\item \code{strength_unit}: Active ingredient strength unit.
}
}
\description{
An Active Ingredient is any component that has medicinal properties, and
supplies pharmacological activity or other direct effect in the diagnosis,
cure, mitigation, treatment or prevention of disease, or to affect the
structure or any function of the body of a human or an animal.
}
\details{
The name and strength of each active ingredient contained in the product is
listed. Information enclosed within brackets represents the salt and
identifies how the ingredient is supplied. This information is only
included for some ingredients. The number in the strength field refers to
the active portion of the drug. For example, for calcium (calcium
carbonate) 200 milligram (mg) - 200 mg is the strength of elemental
calcium, not calcium carbonate.

Health Canada has a reference text hierarchy for ingredient nomenclature.
The International Non Proprietary Names (INN) is used as Health Canada's
standard to assign the preferred name to ingredients. There are other
standards such as the United States Adopted Names (USAN), Martindale,
Merck Index, etc., that are used to code ingredients if they are not
listed in the INN.
}
\examples{
dpd_active_ingredient(id = 48905)

dpd_active_ingredient(name = "afatinib")
}
