% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TherapeuticClass.R
\name{dpd_therapeutic_class}
\alias{dpd_therapeutic_class}
\title{Therapeutic Class}
\usage{
dpd_therapeutic_class(id, lang = c("en", "fr"))
}
\arguments{
\item{id}{Drug product code.}

\item{lang}{Language of the response. One of \code{"en"} or \code{"fr"} for English or
French, respectively.}
}
\value{
A \code{tibble} with columns:
\itemize{
\item \code{drug_code}: Code assigned to each drug product.
\item \code{tc_atc_number}: Anatomical Therapeutic Chemical Code.
\item \code{tc_atc}: Description of the Anatomical Therapeutic Chemical Code.
\item \code{tc_ahfs_number}: American Hospital Formulary Service code.
\item \code{tc_ahfs}: Description of the American Hospital Formulary Service.
}
}
\description{
A drug's Therapeutic Classification (Class) is assigned according to its main
therapeutic use.
}
\examples{
dpd_therapeutic_class(10564)
}
