% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dropout_idx.R
\name{add_dropout_idx}
\alias{add_dropout_idx}
\title{Add Dropout Index to a Data.Frame}
\source{
R/add_dropout_idx.R
}
\usage{
add_dropout_idx(df, q_pos)
}
\arguments{
\item{df}{data.frame containing \code{NA}s}

\item{q_pos}{numeric range of columns that contain question items}
}
\value{
Returns original data frame with column \code{do_idx} added.
}
\description{
Find drop out positions in a data.frame that contains multiple
questions/items that had been asked/worked on sequentially.
This function adds the Dropout Index variable \code{do_idx} to the data.frame which is necessary
for further analyses of dropout.

Use this function \emph{first} to prepare your dropout analysis. Then, keep going by creating
the dropout statistics using \code{\link[=compute_stats]{compute_stats()}}.
}
\details{
Importantly, this function will start counting missing data at the end of the
data frame. Any missing data which is somewhere in between, i.e.
a single item that was skipped or forgotten will not be counted as dropout.
The function will identify sequences of missing data that go until the end of the
data frame and add the number of the last answered question in \code{do_idx}.

The Dropout Index variable \code{do_idx} will therefore code the last item in sequence that is not NA.
If every item is not NA (every item was answered), the \code{do_idx} will be one longer than the number of items in the analysis
to ensure that this is not counted as dropout in further analyses, e.g. in \code{\link[=compute_stats]{compute_stats()}}.

Therefore, the variables must be in the order that they were asked, otherwise analyses
will not be valid.
}
\examples{
dropout <- add_dropout_idx(dropRdemo, 3:54)

}
\seealso{
\code{\link[=compute_stats]{compute_stats()}} which is usually the next step for dropout analysis.
}
