% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_chisq.R
\name{do_chisq}
\alias{do_chisq}
\title{Compute Chi-Squared Test Given a Question Position}
\usage{
do_chisq(
  do_stats,
  chisq_question = max(unique(do_stats$q_idx)),
  sel_cond_chisq = NULL,
  p_sim = TRUE
)
}
\arguments{
\item{do_stats}{data.frame of dropout statistics as computed by \code{\link[=compute_stats]{compute_stats()}}.}

\item{chisq_question}{numeric Which question to compare dropout at.}

\item{sel_cond_chisq}{vector (same class as in conditions variable in original data set) selected conditions.}

\item{p_sim}{boolean Simulate p value parameter (by Monte Carlo simulation)? Defaults to \code{TRUE}.}
}
\value{
Returns test results from chisq.test between experimental conditions at defined question.
}
\description{
This function performs a chi-squared contingency table test on dropout for
a given question in the data. Note that the input data should be in the format as
computed by \code{\link[=compute_stats]{compute_stats()}}.
The test can be performed on either all conditions (excluding total) or on select conditions.
}
\examples{
do_stats <- compute_stats(add_dropout_idx(dropRdemo, 3:54),
by_cond = "experimental_condition",
no_of_vars = 52)

do_chisq(do_stats, 47, c(12, 22), TRUE)

}
\seealso{
\code{\link[=add_dropout_idx]{add_dropout_idx()}} and \code{\link[=compute_stats]{compute_stats()}} which are necessary for the proper data structure.
}
