% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_print.R
\name{do_print}
\alias{do_print}
\alias{do_print.do_stats}
\alias{do_print.do_chi}
\title{Print dropout / test results in a compact, report-ready string}
\usage{
do_print(x, ..., as_markdown = FALSE, print = FALSE)

\method{do_print}{do_stats}(
  x,
  as_markdown = FALSE,
  item = NULL,
  conditions = NULL,
  digits_pct = 1,
  ...
)

\method{do_print}{do_chi}(x, as_markdown = FALSE, digits_pct = 1, digits_stat = 2, ...)
}
\arguments{
\item{x}{An object of class do_chisq (from \code{do_chisq}).}

\item{...}{Additional arguments.}

\item{as_markdown}{Boolean. Should the output be formatted for a Markdown document (e.g. Quarto)? Defaults to FALSE.}

\item{print}{Boolean. Should the output be formatted for printing (e.g. to store in a character vector)? Defaults to FALSE.}

\item{item}{Numeric item index. Default NULL = last item for do_stats.}

\item{conditions}{Optional vector of conditions to include (ignored for totals unless you include them).}

\item{digits_pct}{Digits for percentages.}

\item{digits_stat}{Digits for test statistic.}
}
\value{
Summary of the input object as either a string, markdown-ready or console output.
}
\description{
Print dropout / test results in a compact, report-ready string
}
\examples{
do_stats <- compute_stats(df = add_dropout_idx(dropRdemo, 3:54),
by_cond = "experimental_condition",
no_of_vars = 52)

do_print(do_stats)

}
