% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtms.R
\name{dtms}
\alias{dtms}
\title{Create dtms object}
\usage{
dtms(transient, absorbing, timescale, timestep = NULL, sep = "_")
}
\arguments{
\item{transient}{A character vector of names of the transient states in the state space.}

\item{absorbing}{A character vector of names of the absorbing states in the state space.}

\item{timescale}{A numeric vector with the time scale, including the starting time and the final time.}

\item{timestep}{Numeric (optional), step length of the time scale, will be guessed if NULL (default).}

\item{sep}{Character (optional), separator between short state name and value of time scale. Default is `_`.}
}
\value{
Returns an object of class 'dtms'
}
\description{
This function creates an object of class 'dtms' to be passed to other
functions of the package.
}
\details{
\code{dtms} provides an abstract definition of a multistate model, including
the names of the transient states, the names of the absorbing states, the
values the time scale can take, and the step length of the time scale.

The names of the absorbing and transient states should be provided as
character strings. However, numeric values also work. Factors are not
supported

The step length of the time scale can be a vector with several values, which
allows for unevenly spaced observations. Note, however, that some functions
require one specific value for the step length; e.g.,
\code{dtms_transitions()}. For such functions, if several values are provided
the first value will be used.
}
\examples{
dtms(transient=c("A","B"),
     absorbing="X",
     timescale=1:10)
}
