% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{e_heatmap_matrix}
\alias{e_heatmap_matrix}
\title{Generate heatmap for matrix}
\usage{
e_heatmap_matrix(e, z_val, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{z_val}{Column name for data to be used for heatmap}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Draw heatmap chart in matrix coordinate system
}
\examples{

df <- data.frame("Class" = rep(c("Class1", "Class2", "Class3"),each = 3),
                   "Grade" = c("Grade1","Grade2", "Grade3"),
                  "A" = sample(1:10, 9))

df |> e_chart() |>
 e_matrix(xAxis = "Class", yAxis = "Grade") |>
 e_matrix_parent(value = "Primary", children = c("Class1", "Class2")) |>
 e_matrix_parent(value = "High", children = "Class3") |>
 e_matrix_corner(value = "All School", label = list(
   fontSize = 24, color = "#555", position = "inside")) |>
 e_heatmap(A, coord_system = "matrix") |>
 e_labels(position = "inside",
          formatter = htmlwidgets::JS(
            'function(params){return(params.value[2]);}'),
          color = "#555",
          fontWeight = "bold")

df |> e_chart() |>
 e_matrix(xAxis = "Class", yAxis = "Grade") |>
 e_heatmap_matrix("A") |>
 e_labels(position = "inside",
          formatter = htmlwidgets::JS(
            'function(params){return(params.value[2]);}'),
          fontWeight = "bold") |>
 e_visual_map(A, inRange = list(color = c("#bf444c", "#d88273", "#f6efa6")))

}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-scatter}{Additional arguments}
}
