% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{e_title_matrix}
\alias{e_title_matrix}
\title{Generate Chart Titles for Matrix}
\usage{
e_title_matrix(e, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
helper function for creating titles for every plot in a geofacet style
matrix. This generates the title using the name of the series.
}
\examples{
df <- data.frame(group = rep(letters[1:6], each = 20),
date = seq(from = as.Date("2025-01-01"),
           to = as.Date("2025-01-20"), by = "day"),
temp = sample(c(10:20), size = 60, replace = TRUE))
grid <- data.frame(name = unique(df$group), row = c(1:6), col = c(1:6))

df |>
  group_by(group) |>
  e_chart(date) |>
  e_line(temp, symbol = "none") |>
  e_x_axis(splitNumber = 2) |>
  e_y_axis(splitNumber = 2) |>
  e_geoFacet(legend = FALSE,
             grid = grid,
             margin_trbl = c("t"="25\%"),
             left = "5\%",
             width = "90\%") |>
  e_title(text = "Group Temps") |>
  e_title_matrix(textStyle = list(fontSize = 10),
                 left = "center", top = "top")

}
\seealso{
\href{https://echarts.apache.org/en/option.html#title}{Additional
  arguments}
}
