% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{e_zigzag}
\alias{e_zigzag}
\title{Axis ZigZags}
\usage{
e_zigzag(e, axis = "y", start, end, gap = "3\%", zigzagAmplitude = 10, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{axis}{Axis to apply formatter to. Supports x and y axis}

\item{start, end}{Start and End point for boundary of zigzag. Also supports vectors for generating multiple breaks. Can also support time values.}

\item{gap}{Determines the visual size of the axis break area.
Supports Percentage(String) as proportional value relative to axis. Supports Absolute value(numeric) which refers to literal values in the axis similar to start,end (Not a pixel value).}

\item{zigzagAmplitude}{Amplitude of zigzag. Unit is pixels.}

\item{...}{Any other arguments to pass to breakArea argument.}
}
\description{
helper function for generating axis break zigzags in chart
}
\examples{

df <- data.frame(
              x = c("a", "b", "c", "d", "c"),
              y = c(100, 200, 200, 700, 300)
             )

df |>
  e_charts(x) |>
  e_bar(y) |>
  e_zigzag(axis = 'y', start = 400, end = 500)

df |>
  e_charts(x) |>
  e_bar(y) |>
  e_zigzag(axis = 'y', start = c(125,400), end = c(150,500))
}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-bar}{Additional arguments}
}
