% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ex_output_model_sensitivity}
\alias{ex_output_model_sensitivity}
\title{Example output from the \code{model_sensitivity()} function based on time series}
\format{
A data frame with 16 observations and 12 variables.
\describe{
\item{indicator}{Names of the assessed indicator.}
\item{pressure}{Names of the assessed pressure.}
\item{type}{Type of effect (always direct + indirect for modelling pathway).}
\item{pathway}{Pathway used to assess sensitivity.}
\item{sensitivity}{Overall sensitivity score (-5 to 5).}
\item{adaptive_capacity}{Adaptive capacity score (default is 0).}
\item{uncertainty_sens}{Uncertainty score associated with sensitivity assessment (1 to 3).}
\item{uncertainty_ac}{Uncertainty score associated with adaptive capacity (1 to 3).}
\item{r_sq}{R-squared values from the GAM model, used for scoring.}
\item{p_value}{P-values from the GAM model, determining statistical significance.}
\item{edf}{Effective degrees of freedom from the GAM model, used to adjust scores based on non-linearity risk.}
\item{uncertainty_gam}{Uncertainty score for sensitivity based on
predicted values from a GAM.}
\item{uncertainty_arima}{Uncertainty score for sensitivity based on
predicted values from an ARIMA using the pressure variable as external
predictor.}
}
}
\usage{
ex_output_model_sensitivity
}
\description{
This dataset provides example output from the \code{\link{model_sensitivity}}
function, with sensitivity scores and associated uncertainties for each
indicator-pressure combination. Scores are based on time series data from
\code{\link{pressure_ts_baltic}} and \code{\link{indicator_ts_baltic}}.
}
\keyword{datasets}
