% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulnerability.R
\name{vulnerability}
\alias{vulnerability}
\title{Calculate Vulnerability Scores Using Expert-Based or Model-Derived Overall Exposure
and Sensitivity (Including Adaptive Capacity) Scores}
\usage{
vulnerability(
  exposure_results,
  sensitivity_results,
  method_vulnerability = "mean",
  method_uncertainty = "mean"
)
}
\arguments{
\item{exposure_results}{a data frame containing the output from \code{\link{calc_exposure}}
or \code{\link{model_exposure}}.}

\item{sensitivity_results}{a data frame containing the output from \code{\link{calc_sensitivity}}
or \code{\link{model_sensitivity}}.}

\item{method_vulnerability}{a character string specifying the method for aggregating
the trait based vulnerabilities, available are mean (default), median,
maximum, and minimum.}

\item{method_uncertainty}{a character string specifying the method for the
aggregation of the uncertainty scores from exposure and sensitivity.
Available are mean (default), median, maximum, and minimum.}
}
\value{
a data frame containing state indicator, pressure, type and the vulnerability
and associated uncertainty score.
}
\description{
This function calculates the state indicator ~ pressures ~ type specific vulnerability,
from exposure scores and sensitivity scores. The function can either be used
with the output from \code{\link{calc_exposure}} or \code{\link{model_exposure}}
and \code{\link{calc_sensitivity}} or \code{\link{model_sensitivity}}.
}
\details{
For expert scores the following equation is applied
\itemize{\item(sensitivity + adaptive capacity) + exposure,}
or in case of negative sensitivity values:
\itemize{\item(sensitivity + adaptive capacity) - exposure.}
Trait based sensitivity and adaptive capacity scores will be assessed individually
and then aggregated to one vulnerability score per state indicator and pressure
combination. The aggregation method can be chosen with the \code{method_vulnerability}
argument.
For modelling scores sensitivity and exposure scores are summed up. If the exposure
trend and the sensitivity score have the same direction, e.g. a decreasing trend
in exposure and a negative sensitivity score, then the vulnerability effect
is assigned as positive. If they have opposing directions, e.g. an increasing
exposure, while sensitivity is negative, then the vulnerability is negative.
Vulnerability scores can range only from -10 to 10, aligning with the \emph{ecorisk}
framework.
}
\examples{
# Using demo output data from the calc_exposure() and calc_sensitivity()
# functions:
vulnerability(
  exposure_results = ex_output_calc_exposure,
  sensitivity_results = ex_output_calc_sensitivity
)

\donttest{
  ### Demo Expert-Based Pathway
  # - using the example scoring datasets 'ex_expert_exposure',
  #   and 'ex_expert_sensitivity'

  # Calculate (mean) exposure score:
  exp_expert <- calc_exposure(
    pressures = ex_expert_exposure$pressure,
    components = ex_expert_exposure[ ,2:5],
    uncertainty = ex_expert_exposure[ ,6:9],
    method = "mean" # default
  )
  # Calculate (mean) sensitivity (and adaptive capacity) score:
  sens_ac_expert <- calc_sensitivity(
    indicators = ex_expert_sensitivity$indicator,
    pressures = ex_expert_sensitivity$pressure,
    type = ex_expert_sensitivity$type,
    sensitivity_traits = ex_expert_sensitivity[ ,4:8],
    adaptive_capacities = ex_expert_sensitivity[ ,9:13],
    uncertainty_sens = ex_expert_sensitivity[ ,14:18],
    uncertainty_ac = ex_expert_sensitivity[ ,19:23],
    method = "mean"
  )
  # Calculate vulnerability using the mean (default):
  vulnerability(
    exposure_results = exp_expert,
    sensitivity_results = sens_ac_expert
  )
  # Calculate vulnerability using the median and maximum:
  vulnerability(
    exposure_results = exp_expert,
    sensitivity_results = sens_ac_expert,
    method_vulnerability = "median",
    method_uncertainty = "maximum"
  )


  ### Demo Model-Based Pathway
  # - using the demo time series 'pressure_ts_baltic' and 'indicator_ts_baltic'

  # Model exposure score:
  exp_model <- model_exposure(
    pressure_time_series = pressure_ts_baltic,
    base_years = c(start = 1984, end = 1994),
    current_years = c(start = 2010, end = 2016)
  )

  # Model sensitivity score:
  sens_ac_model <- model_sensitivity(
    indicator_time_series = indicator_ts_baltic,
    pressure_time_series = pressure_ts_baltic,
    current_years = c(start = 2010, end = 2016)
  )
  # Add manually adaptive capacity scores (otherwise zero):
  sens_ac_model$adaptive_capacity <- c(rep(1, 8), rep(-1, 8))

  # Calculate vulnerability using the mean (default):
  vulnerability(
    exposure_results = exp_model,
    sensitivity_results = sens_ac_model
  )

}
}
\seealso{
\code{\link{calc_exposure}}, \code{\link{calc_sensitivity}},
\code{\link{model_exposure}}, \code{\link{model_sensitivity}},
\code{\link{status}}, \code{\link{risk}}
}
