% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_feldt.R
\name{stratified_feldt}
\alias{stratified_feldt}
\title{Stratified Feldt's Coefficient}
\usage{
stratified_feldt(x, s)
}
\arguments{
\item{x}{A data frame or matrix containing item responses, with rows as
subjects and columns as items. Items are assumed to be ordered by stratum.}

\item{s}{A numeric vector giving the number of items in each stratum. The
sum of \code{s} must equal \code{ncol(x)}.}
}
\value{
A named list with:
\describe{
\item{stratified.feldt}{Stratified Feldt's coefficient.}
}
}
\description{
Compute the stratified Feldt's coefficient for a test composed of several
item strata (e.g., subtests or subscales).
}
\details{
Stratified Feldt's coefficient is an estimate of internal consistency
reliability for a composite test formed by multiple strata.
}
\examples{
data(data.m)
stratified_feldt(data.m, c(13, 12, 6))

}
