% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{epiworld-transmissions}
\alias{epiworld-transmissions}
\alias{get_transmissions}
\title{Transmission network}
\usage{
get_transmissions(x)
}
\arguments{
\item{x}{An object of class \code{\link{epiworld_sir}}, \code{\link{epiworld_seir}}, etc.
(any model).}
}
\value{
\itemize{
\item The function \code{get_transmissions} returns a \code{data.frame} with the following
columns: \code{date}, \code{source}, \code{target}, \code{virus_id}, \code{virus}, and \code{source_exposure_date}.
}
}
\description{
Transmission edges, including seeded infections (\code{source = -1}).
}
\details{
The function \code{get_transmissions} includes the seeded infections, with the
\code{source} column coded as \code{-1}.
}
\examples{
# SEIR Connected model
seirconn <- ModelSEIRCONN(
  name              = "Disease",
  n                 = 10000,
  prevalence        = 0.1,
  contact_rate      = 2.0,
  transmission_rate = 0.8,
  incubation_days   = 7.0,
  recovery_rate     = 0.3
)

set.seed(937)
run(seirconn, 50)

# Get transmission data
head(get_transmissions(seirconn))

}
\concept{Network outputs}
\concept{model-utility-functions}
