% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VizEquiMap.R
\name{VizEquiMap}
\alias{VizEquiMap}
\title{Maps A Two-Dimensional Variable On A Cylindrical Equidistant Projection}
\usage{
VizEquiMap(
  data,
  lon,
  lat,
  varu = NULL,
  varv = NULL,
  toptitle = NULL,
  sizetit = NULL,
  caption = NULL,
  units = NULL,
  brks = NULL,
  cols = NULL,
  bar_limits = NULL,
  triangle_ends = NULL,
  col_inf = NULL,
  col_sup = NULL,
  colNA = NULL,
  color_fun = ClimPalette(),
  square = TRUE,
  filled.continents = FALSE,
  filled.oceans = FALSE,
  country.borders = FALSE,
  coast_color = NULL,
  coast_width = 1,
  lake_color = NULL,
  shapefile = NULL,
  shapefile_color = NULL,
  shapefile_lwd = 1,
  contours = NULL,
  brks2 = NULL,
  contour_lwd = 0.5,
  contour_color = "black",
  contour_lty = 1,
  contour_draw_label = TRUE,
  contour_label_scale = 1,
  dots = NULL,
  dot_symbol = 4,
  dot_size = 1,
  mask = NULL,
  mask_color = "white",
  arr_subsamp = floor(length(lon)/30),
  arr_scale = 1,
  arr_ref_len = 15,
  arr_units = "m/s",
  arr_scale_shaft = 1,
  arr_scale_shaft_angle = 1,
  axelab = TRUE,
  labW = FALSE,
  lab_dist_x = NULL,
  lab_dist_y = NULL,
  degree_sym = FALSE,
  intylat = 20,
  intxlon = 20,
  xlonshft = 0,
  ylatshft = 0,
  xlabels = NULL,
  ylabels = NULL,
  axes_tick_scale = 1,
  axes_label_scale = 1,
  drawleg = TRUE,
  vertical = FALSE,
  subsampleg = NULL,
  bar_extra_labels = NULL,
  draw_bar_ticks = TRUE,
  draw_separators = FALSE,
  triangle_ends_scale = 1,
  bar_label_digits = 4,
  bar_label_scale = 1,
  units_scale = 1,
  bar_tick_scale = 1,
  bar_extra_margin = rep(0, 4),
  include_lower_boundary = TRUE,
  include_upper_boundary = TRUE,
  hatching_mask = NULL,
  hatching_density = 10,
  hatching_angle = 45,
  hatching_color = "#252525",
  hatching_lwd = 0.5,
  hatching_cross = FALSE,
  boxlim = NULL,
  boxcol = "purple2",
  boxlwd = 5,
  margin_scale = rep(1, 4),
  title_scale = 1,
  caption_size = 0.8,
  numbfig = NULL,
  fileout = NULL,
  width = 8,
  height = 5,
  size_units = "in",
  res = 100,
  var = NULL,
  ...
)
}
\arguments{
\item{data}{Array with the values at each cell of a grid on a regular 
rectangular or gaussian grid. The array is expected to have two 
dimensions: c(latitude, longitude). Longitudes can be in ascending or 
descending order and latitudes in any order. It can contain NA values 
(coloured with 'colNA'). Arrays with dimensions c(longitude, latitude) 
will also be accepted but 'lon' and 'lat' will be used to disambiguate so 
this alternative is not appropriate for square arrays. It is allowed that
the positions of the longitudinal and latitudinal coordinate dimensions 
are interchanged.}

\item{lon}{Numeric vector of longitude locations of the cell centers of the 
grid of 'data', in ascending or descending order (same as 'data'). Expected 
to be regularly spaced, within either of the ranges [-180, 180] or 
[0, 360]. Data for two adjacent regions split by the limits of the 
longitude range can also be provided, e.g. \code{lon = c(0:50, 300:360)} 
('data' must be provided consitently).}

\item{lat}{Numeric vector of latitude locations of the cell centers of the 
grid of 'data', in any order (same as 'data'). Expected to be from a regular 
rectangular or gaussian grid, within the range [-90, 90].}

\item{varu}{Array of the zonal component of wind/current/other field with 
the same dimensions as 'data'. It is allowed that the positions of the 
longitudinal and latitudinal coordinate dimensions are interchanged.}

\item{varv}{Array of the meridional component of wind/current/other field 
with the same dimensions as 'data'. It is allowed that the positions of the 
longitudinal and latitudinal coordinate dimensions are interchanged.}

\item{toptitle}{Top title of the figure, scalable with parameter 
'title_scale'.}

\item{sizetit}{Scale factor for the figure top title provided in parameter 
'toptitle'. Deprecated. Use 'title_scale' instead.}

\item{caption}{A character string of the caption located at the left-bottom of
the plot. Captions with multiple lines can be constructed using string 
manipulation functions like \code{paste()} or \code{paste0()}, using 
\code{"\n"} to indicate line breaks.}

\item{units}{Title at the top of the colour bar, most commonly the units of 
the variable provided in parameter 'data'.}

\item{brks, cols, bar_limits, triangle_ends}{Usually only providing 'brks' is 
enough to generate the desired colour bar. These parameters allow to 
define n breaks that define n - 1 intervals to classify each of the values 
in 'data'. The corresponding grid cell of a given value in 'data' will be 
coloured in function of the interval it belongs to. These parameters are 
sent to \code{ColorBar()} to generate the breaks and colours. Additional 
colours for values beyond the limits of the colour bar are also generated 
and applied to the plot if 'bar_limits' or 'brks' and 'triangle_ends' are 
properly provided to do so. See ?ColorBar for a full explanation.}

\item{col_inf, col_sup, colNA}{Colour identifiers to colour the values in 
'data' that go beyond the extremes of the colour bar and to colour NA 
values, respectively. 'colNA' takes attr(cols, 'na_color') if available by 
default, where cols is the parameter 'cols' if provided or the vector of 
colors returned by 'color_fun'. If not available, it takes 'pink' by 
default. 'col_inf' and 'col_sup' will take the value of 'colNA' if not 
specified. See ?ColorBar for a full explanation on 'col_inf' and 'col_sup'.}

\item{color_fun, subsampleg, bar_extra_labels, draw_bar_ticks}{Set of 
parameters to control the visual aspect of the drawn colour bar 
(1/3). See ?ColorBar for a full explanation.}

\item{square}{Logical value to choose either to draw a coloured square for 
each grid cell in 'data' (TRUE; default) or to draw contour lines and fill 
the spaces in between with colours (FALSE). In the latter case, 
'filled.continents' will take the value FALSE if not specified.}

\item{filled.continents}{Colour to fill in drawn projected continents. 
If 'square = FALSE', it is set as FALSE.
If set to FALSE (default), the continents are not filled.}

\item{filled.oceans}{A logical value or the color name to fill in drawn 
projected oceans. The default value is FALSE. If it is TRUE, the default
colour is "light blue".}

\item{country.borders}{A logical value indicating if the country borders 
should be plotted (TRUE) or not (FALSE). It only works when 
'filled.continents' is FALSE. The default value is FALSE.}

\item{coast_color}{Colour of the coast line of the drawn projected continents.
Takes the value gray(0.5) by default.}

\item{coast_width}{Line width of the coast line of the drawn projected 
continents. Takes the value 1 by default.}

\item{lake_color}{Colour of the lake or other water body inside continents.
The default value is NULL.}

\item{shapefile}{A character string of the path to a .rds file or a list 
object containinig shape file data. If it is a .rds file, it should contain
a list. The list should contains 'x' and 'y' at least, which indicate the 
location of the shape. The default value is NULL.}

\item{shapefile_color}{Line color of the shapefile.}

\item{shapefile_lwd}{Line width of the shapefile. The default value is 1.}

\item{contours}{Array of same dimensions as 'data' to be added to the plot 
and displayed with contours. Parameter 'brks2' is required to define the 
magnitude breaks for each contour curve. Disregarded if 'square = FALSE'.
It is allowed that the positions of the longitudinal and latitudinal 
coordinate dimensions are interchanged.}

\item{brks2}{Vector of magnitude breaks where to draw contour curves for the 
array provided in 'contours' or if 'square = FALSE'.}

\item{contour_lwd}{Line width of the contour curves provided via 'contours' 
and 'brks2', or if 'square = FALSE'.}

\item{contour_color}{Line color of the contour curves provided via 'contours' 
and 'brks2', or if 'square = FALSE'.}

\item{contour_lty}{Line type of the contour curves. Takes 1 (solid) by 
default. See help on 'lty' in par() for other accepted values.}

\item{contour_draw_label}{A logical value indicating whether to draw the 
contour labels or not. The default value is TRUE.}

\item{contour_label_scale}{Scale factor for the superimposed labels when 
drawing contour levels.}

\item{dots}{Array of same dimensions as 'data' or with dimensions 
c(n, dim(data)), where n is the number of dot/symbol layers to add to the 
plot. A value of TRUE at a grid cell will draw a dot/symbol on the 
corresponding square of the plot. By default all layers provided in 'dots' 
are plotted with dots, but a symbol can be specified for each of the 
layers via the parameter 'dot_symbol'. It is allowed that the positions of
the longitudinal and latitudinal coordinate dimensions are interchanged.}

\item{dot_symbol}{Single character/number or vector of characters/numbers 
that correspond to each of the symbol layers specified in parameter 'dots'. 
If a single value is specified, it will be applied to all the layers in 
'dots'. Takes 4 (cross) by default. See 'pch' in par() for 
additional accepted options.}

\item{dot_size}{Scale factor for the dots/symbols to be plotted, specified 
in 'dots'. If a single value is specified, it will be applied to all 
layers in 'dots'. Takes 1 by default.}

\item{mask}{An array with the same dimensions as 'data' with values in the 
range of [0, 1] or logical, indicating the opacity of the mask over each 
grid point. Cells with a 0 or FALSE will result in a totally opaque 
superimposed pixel coloured in 'mask_color', whereas cells with a 1 or TRUE 
will have no mask and remain totally visible. If the array is numeric, values
between 0 and 1 will have shades of transparency.}

\item{mask_color}{Color of the mask. The default value is 'white'.}

\item{arr_subsamp}{Subsampling factor to select a subset of arrows in 
'varu' and 'varv' to be drawn. Only one out of arr_subsamp arrows will 
be drawn. Takes 1 by default.}

\item{arr_scale}{Scale factor for drawn arrows from 'varu' and 'varv'. 
Takes 1 by default.}

\item{arr_ref_len}{Length of the refence arrow to be drawn as legend at the 
bottom of the figure (in same units as 'varu' and 'varv', only affects the
legend for the wind or variable in these arrays). Defaults to 15.}

\item{arr_units}{Units of 'varu' and 'varv', to be drawn in the legend. 
Takes 'm/s' by default.}

\item{arr_scale_shaft}{Parameter for the scale of the shaft of the arrows 
(which also depend on the number of figures and the arr_scale parameter). 
Defaults to 1.}

\item{arr_scale_shaft_angle}{Parameter for the scale of the angle of the 
shaft of the arrows (which also depend on the number of figure and the 
arr_scale parameter). Defaults to 1.}

\item{axelab}{Whether to draw longitude and latitude axes or not. 
TRUE by default.}

\item{labW}{Whether to label the longitude axis with a 'W' instead of minus 
for negative values. Defaults to FALSE.}

\item{lab_dist_x}{A numeric of the distance of the longitude labels to the 
box borders. The default value is NULL and is automatically adjusted by 
the function.}

\item{lab_dist_y}{A numeric of the distance of the latitude labels to the 
box borders. The default value is NULL and is automatically adjusted by 
the function.}

\item{degree_sym}{A logical indicating whether to include degree symbol 
(30° N) or not (30N; default).}

\item{intylat}{Interval between latitude ticks on y-axis, in degrees. 
Defaults to 20.}

\item{intxlon}{Interval between latitude ticks on x-axis, in degrees. 
Defaults to 20.}

\item{xlonshft}{A numeric of the degrees to shift the latitude ticks. The 
default value is 0.}

\item{ylatshft}{A numeric of the degrees to shift the longitude ticks. The
default value is 0.}

\item{xlabels}{A vector of character string of the custumized x-axis labels.
The values should correspond to each tick, which is decided by the longitude
and parameter 'intxlon'. The default value is NULL and the labels will be
automatically generated.}

\item{ylabels}{A vector of character string of the custumized y-axis labels.
The values should correspond to each tick, which is decided by the latitude
and parameter 'intylat'. The default value is NULL and the labels will be
automatically generated.}

\item{axes_tick_scale}{Scale factor for the tick lines along the longitude 
and latitude axes.}

\item{axes_label_scale}{Scale factor for the labels along the longitude 
and latitude axes.}

\item{drawleg}{Whether to plot a color bar (legend, key) or not. Defaults to 
TRUE. It is not possible to plot the colour bar if 'add = TRUE'. Use 
ColorBar() and the return values of PlotEquiMap() instead.}

\item{vertical}{TRUE/FALSE for vertical/horizontal colour bar. Default is 
FALSE. Parameters 'width' and 'height' might need to be modified to
accommodate the vertical colour bar.}

\item{draw_separators, triangle_ends_scale, bar_label_digits}{Set of 
parameters to control the visual aspect of the drawn colour bar 
(2/3). See ?ColorBar for a full explanation.}

\item{bar_label_scale, units_scale, bar_tick_scale, bar_extra_margin}{Set of
parameters to control the visual aspect of the drawn colour bar (3/3). 
See ?ColorBar for a full explanation.}

\item{include_lower_boundary}{Logical value indicating whether to include
the minimum value of the field. Takes TRUE by default.}

\item{include_upper_boundary}{Logical value indicating whether to include
the maximum value of the field. Takes TRUE by default.}

\item{hatching_mask}{Logical or binary (0/1) array with two named dimensions:
c(latitude, longitude). Hatching is applied to grid cells where
'hatching_mask' is TRUE (or 1). Arrays with dimensions c(longitude, latitude)
are also accepted, but the resulting hatching may appear transposed. To
ensure correct alignment with the map, provide 'data'. The function will
compare the dimension order of 'hatching_mask' and 'data', and automatically
transpose 'hatching_mask' if the latitude and longitude dimensions appear to
be reversed.}

\item{hatching_density}{The density of shading lines, in lines per inch. A
zero value of density means no shading nor filling, whereas negative values
and NA suppress shading (and so allow color filling). NULL means that no
shading lines are drawn. Default is 10.}

\item{hatching_angle}{The slope of shading lines, given as an angle in degrees
(counter-clockwise). Default is 45.}

\item{hatching_color}{Color of the hatching lines. Default is
\code{"#252525"}.}

\item{hatching_lwd}{The line width, a positive number. The interpretation is
device-specific, and some devices do not implement line widths less than
one. Default is 0.5.}

\item{hatching_cross}{A logical value indicating crosshatching. If TRUE, adds
a second set of lines in the opposite angle. Default is FALSE.}

\item{boxlim}{Limits of a box to be added to the plot, in degrees: 
c(x1, y1, x2, y2). A list with multiple box specifications can also be 
provided.}

\item{boxcol}{Colour of the box lines. A vector with a colour for each of 
the boxes is also accepted. Defaults to 'purple2'.}

\item{boxlwd}{Line width of the box lines. A vector with a line width for 
each of the boxes is also accepted. Defaults to 5.}

\item{margin_scale}{Scale factor for the margins around the map plot, with 
the format c(y1, x1, y2, x2). Defaults to rep(1, 4). If drawleg = TRUE, 
then margin_scale[1] is subtracted 1 unit.}

\item{title_scale}{Scale factor for the figure top title. Defaults to 1.}

\item{caption_size}{Scale factor for the figure caption. Default is 0.8 (1 if
vertical = TRUE).}

\item{numbfig}{Number of figures in the layout the plot will be put into. 
A higher numbfig will result in narrower margins and smaller labels, 
axe labels, ticks, thinner lines, ... Defaults to 1.}

\item{fileout}{File where to save the plot. If not specified (default) a 
graphics device will pop up. Extensions allowed: eps/ps, jpeg, png, pdf, 
bmp and tiff.}

\item{width}{File width, in the units specified in the parameter 'size_units' 
(inches by default). Takes 8 by default.}

\item{height}{File height, in the units specified in the parameter 
'size_units' (inches by default). Takes 5 by default.}

\item{size_units}{Units of the size of the device (file or window) to plot 
in. Inches ('in') by default. See ?Devices and the creator function of 
the corresponding device.}

\item{res}{Resolution of the device (file or window) to plot in. See 
?Devices and the creator function of the corresponding device.}

\item{var}{Deprecated. Use 'data' instead.}

\item{\dots}{Arguments to be passed to the method. Only accepts the following 
graphical parameters:\cr
adj ann ask bg bty cex.sub cin col.axis col.lab col.main col.sub cra crt 
csi cxy err family fg font font.axis font.lab font.main font.sub lend 
lheight ljoin lmitre mex mfcol mfrow mfg mkh omd omi page pch pin plt 
pty smo srt tcl usr xaxp xaxs xaxt xlog xpd yaxp yaxs yaxt ylbias ylog \cr
For more information about the parameters see `par`.}
}
\value{
\item{brks}{
 Breaks used for colouring the map (and legend if drawleg = TRUE).
}
\item{cols}{
 Colours used for colouring the map (and legend if drawleg = TRUE). Always 
   of length length(brks) - 1.
}
\item{col_inf}{
 Colour used to draw the lower triangle end in the colour bar (NULL if not 
  drawn at all).
}
\item{col_sup}{
 Colour used to draw the upper triangle end in the colour bar (NULL if not 
  drawn at all).
}
}
\description{
Map longitude-latitude array (on a regular rectangular or gaussian grid) 
on a cylindrical equidistant latitude and longitude projection with coloured 
grid cells. Only the region for which data has been provided is displayed. 
A colour bar (legend) can be plotted and adjusted. It is possible to draw 
superimposed arrows, dots, symbols, contour lines and boxes. A number of 
options is provided to adjust the position, size and colour of the 
components. Some parameters are provided to add and adjust the masks that
include continents, oceans, and lakes. This plot function is compatible with
figure layouts if colour bar is disabled.
}
\examples{
ano <- s2dv::Ano_CrossValid(map_temp$exp, map_temp$obs, memb = FALSE,
                           dat_dim = c('dat', 'member'), memb_dim = 'member')
data <- s2dv::MeanDims(ano$exp, "member")
lats <- attr(map_temp$exp, "Variables")$common$lat
lons <- attr(map_temp$exp, "Variables")$common$lon

VizEquiMap(data[1, 1, 1, 1, , ], lon = lons, lat = lats,
          toptitle = 'Near-surface temperature anomaly, Nov. 2000',
          filled.continents = FALSE, title_scale = 0.7,
          caption = paste0("This is a test caption."))

}
