% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.R
\name{perm}
\alias{perm}
\title{Calculate Number of Permutations A(n, k)}
\usage{
perm(n, k)
}
\arguments{
\item{n}{Integer. Total number of items (non-negative integer).}

\item{k}{Integer. Number of items selected for permutation (non-negative integer, must be <= n).}
}
\value{
Numeric. The permutation count A(n, k) (returns Inf for very large n).
}
\description{
Calculates the total number of ways to arrange k items selected from n distinct items, i.e.,
the number of permutations A(n, k) = n! / (n - k)!.
This function is intended for moderate n and k. For very large numbers, consider supporting the 'gmp' package.
}
\examples{
perm(8, 4)      # 1680
perm(5, 2)      # 20
perm(10, 0)     # 1
perm(5, 6)      # 0
}
