% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data.R
\name{sim_data}
\alias{sim_data}
\alias{mcar}
\alias{mcar2}
\title{Simulate raw data}
\usage{
sim_data(
  blocks = 50,
  block_length = 365,
  distn = "exp",
  missing_fn = mcar,
  missing_args = formals(missing_fn)$missing_args,
  ...
)

mcar(
  sim_data,
  blocks,
  block_length,
  missing_args = list(p0miss = 0, min = 0, max = 0.5)
)

mcar2(sim_data, missing_args = list(pmiss = 0.5))
}
\arguments{
\item{blocks}{A numeric scalar. The number of blocks of data required.
Usually, this will be a positive integer, but \code{blocks = 0} returns a list
containing in the input arguments, in particular, \code{distn}, \code{distn_args}
and \code{block_length}. This feature is provided so that a simulation setup
could be replicated in without actually simulating data.}

\item{block_length}{A numeric scalar. The number of raw observations per
block.}

\item{distn}{A character scalar. Specifies the distribution from which raw
data are simulated. The name in the \code{xxx} part of the \verb{dxxx, pxxx, qxxx}
and \code{rxxx} distributional functions in the \code{stats} package. See
\code{\link[stats:Distributions]{stats::Distributions}}.}

\item{missing_fn}{A function to simulate the positions of the missing values
within each block year. See \strong{Details}.}

\item{missing_args}{Arguments to be passed to \code{missing_fn}. If \code{missing_fn}
is \code{mcar} then a subset of \code{p0miss}, \code{min} and \code{max} may be supplied
in the list \code{missing_args}. The values of the remaining components will be
set at their default values.}

\item{...}{Further arguments to the function \code{stats::rxxx}. The argument \code{n}
is set within \code{sim_data} to be equal to \code{block_length * blocks}.}

\item{sim_data}{A numeric vector of raw observations into, some of which
will be made missing.}
}
\value{
If \code{blocks > 0}, a list with the following components:
\itemize{
\item \code{data_full}: simulated raw data with no missing values.
\item \code{data_miss}: simulated data after missing values have been created.
\item \verb{blocks, block_length}: the respective input values of \code{blocks} and
\code{block_length}.
\item \code{block}: a block indicator vector, suitable as an argument to \code{\link{gev_mle}}.
\item \code{distn}: the input argument \code{distn}.
\item \code{distn_args}: further arguments to \code{stats::rxxx} supplied via \code{...}.
}

If \code{blocks = 0}, a list containing all the inputs arguments.
}
\description{
Simulates data from a user-supplied distribution and creates missing values
artificially. Functions \code{mcar} and \code{mcar2} provides an example mechanisms
for doing this based on a Missing Completely At Random (MCAR) assumption.
}
\details{
The function \code{missing_fn} must return a, possibly empty,
subset of \code{c(1, 2, ..., block_length)}. This function is applied within
each simulated block, independently of other blocks.

The default function \code{mcar} simulates the numbers of missing values in the
blocks as follows.
\itemize{
\item A proportion \code{p0miss} of the blocks have \strong{no} missing values.
\item In the other blocks, the number of missing values is
\code{ceiling(prop_miss * block_length)}, where \code{prob_miss} is a value
simulated from a Uniform(\code{min}, \code{max}) distribution. The positions of
these missing values within the block is random.
}

The function \code{mcar2} identifies at random a proportion \code{pmiss} of the
simulated raw observations to become missing.

Care may need to be taken if these simulated data are used as input to
\code{\link{gev_mle}} using an approach that discards block maxima based on more
than a certain percentage of  missing values, that is, with \code{discard > 0}.
For example, using the default argument \code{blocks = 50} and
\code{missing_fn = mcar}, with its default \code{missing_args}, may result
in a sample size of retained block maxima that contains insufficient
information to make reliable inferences, leading to difficulties finding
an appropriate MLE for the shape parameter \eqn{\xi} and/or a singular
observed information matrix.
}
\examples{
# Using missing_fn = mcar
sdata <- sim_data()

# Using missing_fn = mcar2
sdata2 <- sim_data(missing_fn = mcar2)
}
\seealso{
\code{\link{gev_mle}} and \code{\link{gev_bayes}}.
}
