% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abm-pso.R
\name{abm.pso}
\alias{abm.pso}
\title{abm.pso}
\usage{
abm.pso(objective, options = NULL)
}
\arguments{
\item{objective}{An instance of ObjectiveFunction (or subclass) class \link{ObjectiveFunction}}

\item{options}{An apropiate instance from a sublclass of \link{Options} class}
}
\description{
An implementaion of Particle Swarm Optimization
method for parameter estimation of Individual-based models.
}
\examples{
\dontrun{
 f<- PlainFunction$new(f0.rosenbrock2)

 f$Parameter(name="x1",min=-100,max=100)
 f$Parameter(name="x2",min=-100,max=100)

 extremize("pso", f)
}

}
\references{
[1] Kennedy, J., & Eberhart, R. (1995). Particle swarm optimization.
In Proceedings of ICNN 95 - International Conference on Neural
Networks (Vol. 4, pp. 1942-1948). IEEE.

[2] Poli, R., Kennedy, J., & Blackwell, T. (2007). Particle swarm optimization.
Swarm Intelligence, 1(1), 33-57.
}
