% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHELF_funcs.R
\name{plot_expert_opinion}
\alias{plot_expert_opinion}
\title{Plotting Pooled Expert Opinion}
\usage{
plot_expert_opinion(
  object,
  xl_plt = NULL,
  xu_plt = NULL,
  weights = NULL,
  St_indic = 0
)
}
\arguments{
\item{object}{Either a object of class elicitation (from \code{SHELF}) or a dataframe with parameters of the distribution (see Example below).}

\item{xl_plt}{Optionally set the lower bound for the plot}

\item{xu_plt}{Optionally set the upper bound for the plot}

\item{weights}{A vector with the weight of each expert. If omitted, set to equal weights.}

\item{St_indic}{Set to 1 if you want to truncate the distributions to be between 0 and 1.}
}
\value{
A ggplot with pooled distributions.
}
\description{
Returns a ggplot with the individual expert opinions along with the pooled distributions (both linear and logarithmic).
}
\examples{
 expert_df <- data.frame(dist = c("norm","t"), #Distribution Name
                         wi = c(1/3,2/3), #Expert weights
                         param1 = c(0.3,0.40), #Parameter 1
                         param2 = c(0.05,0.05),# Parameter 2
                         param3 = c(NA,3)) #Parameter 3: Only t-distribution
\donttest{ 
plot_expert_opinion(expert_df , weights = expert_df$wi)
}
                                                        
}
