% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gencovmat.R
\name{gencovariancemat}
\alias{gencovariancemat}
\title{Function that generates a covariance matrix taking as input a correlation matrix and a standard deviation matrix or value.}
\usage{
gencovariancemat(
  correlation_matrix,
  sd_matrix,
  withinf,
  label_list = NULL,
  nlfA,
  nlfB
)
}
\arguments{
\item{correlation_matrix}{Matrix - Expected correlation between combinations of factor levels}

\item{sd_matrix}{Numeric or matrix - Standard deviation value or matrix of standard deviation values for combinations of factor levels.}

\item{withinf}{Character- Factor for which measurements are repeated, options are NULL, "fA", "fB" and "both". If NULL (default) independent measurements will be considered.}

\item{label_list}{List length 2 - Names of factor levels}

\item{nlfA}{Integer - number of levels of factor A}

\item{nlfB}{Integer - number of levels of factor B}
}
\value{
Covariance matrix
}
\description{
May be run independently or internally as part of 'calculate_mean_matrix'.
}
\examples{

meanvals <- c(seq(3,9,2),seq(2,8,2),seq(1,7,2))
mean_matrix <- matrix(meanvals, 3, 4, byrow = TRUE,
                   dimnames = list(A=LETTERS[1:3], B=letters[1:4]))

mean_matrix
sd_matrix <- mean_matrix*0.2

cor_matrix <- gencorrelationmat(mean_matrix = mean_matrix,
                                rho = 0.7, withinf = "fB", nlfA = 3, nlfB = 4)

gencovariancemat(cor_matrix, sd_matrix, withinf = "fB", nlfA = 3, nlfB = 4)

##correlation gradient over levels of factor B
cor_matrix <- gencorrelationmat(mean_matrix = mean_matrix,
                                rho = c(0.7, 0.4), withinf = "fB", nlfA = 3, nlfB = 4)

gencovariancemat(cor_matrix, sd_matrix, withinf = "fB", nlfA = 3, nlfB = 4)

}
