% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_va_fd.R
\name{get_va_fd}
\alias{get_va_fd}
\title{Value added induced by final demand}
\usage{
get_va_fd(
  wio_object,
  va_type = "TOTAL",
  geo_orig = "WLD",
  sec_orig = "TOTAL",
  geo_fd = "WLD",
  sec_fd = "TOTAL",
  intra = FALSE
)
}
\arguments{
\item{wio_object}{A \code{wio} object}

\item{va_type}{String character with the type of VA induced (VA domestically
absorbed \code{"VAD"} or exported \code{"VAX"}) or the equivalent inducing VA
(domestic final demand \code{"DFD"} or foreign final demand
\code{"FFD"}). That is, \code{"VAD"} and \code{"DFD"} will produce the
same result, and so will \code{"VAX"} and \code{"FFD"}. Default is both,
i.e. \code{"TOTAL"} VA o total demand.}

\item{geo_orig}{String character with code of country or country group
generating value added, i.e., exporter. Default is \code{"all"})}

\item{sec_orig}{String character with code of sector or sector group
generating value added. Default: \code{"all"})}

\item{geo_fd}{String character with code of country (or country group)
of final demand (inducing the generation of VA)}

\item{sec_fd}{String character with code of sector (or sector group)
of final demand (inducing the generation of VA)}

\item{intra}{Boolean for inclusion of intra-regional exports
(default: \code{FALSE})}
}
\value{
Matrix with source and destination of value added.
}
\description{
Details of both geographical and sector origin of the
VA induced by final demand. Equivalent to the
OECD's Origin of Value added in Final Demand (\code{FDVA_BSCI}), but with much
more flexible geographical and sector options.
}
\examples{
wio <- make_wio("iciotest")
# Get USA's total VA in services induced by China's manufacturing
get_va_fd(wio, geo_orig = "USA", sec_orig = "SRVWC",
         geo_fd = "CHN", sec_fd = "MANUF")
# Get world VA exported (VAX), i.e., world VA induced by the rest of
# the world not domestically absorbed
get_va_fd(wio, "VAX", "WLD", "TOTAL", "WLD", "TOTAL")
}
