% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_lll}
\alias{fn_lll}
\title{Linear–logistic–linear function}
\usage{
fn_lll(t, t1, t2, dt, k, beta = NULL)
}
\arguments{
\item{t}{A numeric vector of input values (e.g., time).}

\item{t1}{The onset time of the response. The function is 0 for all values
less than or equal to \code{t1}.}

\item{t2}{The time when the initial linear phase ends and the logistic phase
begins. Must be greater than \code{t1}.}

\item{dt}{Duration of the logistic phase. Defines \code{t3 = t2 + dt} and must
be positive.}

\item{k}{Upper asymptote (maximum level) of the logistic component.}

\item{beta}{Slope of the final linear phase after \code{t3} (often negative).}
}
\value{
A numeric vector of the same length as \code{t}, representing the
  function values.
}
\description{
A piecewise function that models (i) an initial linear increase from zero,
(ii) a smooth logistic rise toward an upper asymptote, and (iii) a final
linear phase.
}
\details{
\if{html}{
\deqn{
f(t; t_1, t_2, dt, k, \beta) =
\begin{cases}
0 & \text{if } t \le t_1 \\
\dfrac{k/2}{t_2 - t_1}\,(t - t_1) & \text{if } t_1 < t \le t_2 \\
\dfrac{k}{1 + \exp\left(-2\,\dfrac{t - t_2}{t_2 - t_1}\right)} & \text{if } t_2 < t \le t_3 \\
\dfrac{k}{1 + \exp\left(-2\,\dfrac{t_3 - t_2}{t_2 - t_1}\right)} + \beta\,(t - t_3)
  & \text{if } t > t_3
\end{cases}
}
}

where \eqn{t_3 = t_2 + dt}.

The function is continuous at \code{t1}, \code{t2}, and \code{t3}. It is
differentiable at \code{t2} by construction (the linear slope matches the
logistic derivative at \code{t2}). It is not differentiable at \code{t1}, and
it is generally not differentiable at \code{t3} unless \code{beta} matches
the logistic derivative at \code{t3}.
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_lll",
  params = c(t1 = 25, t2 = 35, dt = 45, k = 100, beta = -1),
  interval = c(0, 100),
  n_points = 2000,
  auc_label_size = 3
)
}
