% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{dfr_gompertz}
\alias{dfr_gompertz}
\title{Gompertz Distribution (Exponential Growth Hazard)}
\usage{
dfr_gompertz(a = NULL, b = NULL)
}
\arguments{
\item{a}{Initial hazard rate at t=0. Must be positive.}

\item{b}{Growth rate of the hazard. Must be positive.}
}
\value{
A \code{dfr_dist} object with analytical rate, cumulative hazard,
and score function.
}
\description{
Creates a DFR distribution with Gompertz hazard function.
The Gompertz models exponentially increasing failure rate, often used
for biological aging and wear-out processes that accelerate over time.
}
\details{
The Gompertz distribution has:
\itemize{
\item Hazard: \eqn{h(t) = a \cdot e^{bt}}
\item Cumulative hazard: \eqn{H(t) = (a/b)(e^{bt} - 1)}
\item Survival: \eqn{S(t) = \exp(-(a/b)(e^{bt} - 1))}
}
}
\section{Reliability Interpretation}{

Use Gompertz for:
\itemize{
\item Aging systems where failure rate grows exponentially
\item Biological mortality (human lifespans)
\item Corrosion/degradation with accelerating kinetics
}

When b is small, Gompertz approximates exponential early in life.
As b increases, wear-out acceleration becomes more pronounced.
}

\examples{
# Aging system: initial hazard 0.001, doubling every 1000 hours
# b = log(2)/1000 gives doubling time of 1000
system <- dfr_gompertz(a = 0.001, b = log(2)/1000)

# Hazard at various ages
h <- hazard(system)
h(0)      # 0.001 (initial)
h(1000)   # 0.002 (doubled)
h(2000)   # 0.004 (quadrupled)

# Survival probability
S <- surv(system)
S(5000)   # probability of surviving 5000 hours

}
