% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_brand.R
\name{write_brand}
\alias{write_brand}
\title{Write Brand YAML for Quarto Projects}
\usage{
write_brand(path = here::here(), restore_logos = TRUE)
}
\arguments{
\item{path}{Character. Path to the project directory. Default is current project
root via \code{\link[here]{here}}.}

\item{restore_logos}{Logical. Restore logo content from system configuration.
Default is \code{TRUE}.}
}
\value{
Invisibly returns the path to the file.
}
\description{
Creates or opens a \code{_brand.yml} file in a Quarto project for editing.
If the file already exists, it is opened directly. If global froggeR brand
settings exist, those are used as the starting point. Otherwise, the template
is downloaded from the
\href{https://github.com/kyleGrealis/frogger-templates}{frogger-templates}
repository.
}
\details{
The \code{_brand.yml} file defines your visual identity for Quarto documents:
colors, logos, typography, and more. See the
\href{https://posit-dev.github.io/brand-yml/}{brand.yml specification} for
the full list of available options.

Use \code{\link{save_brand}} to persist your project-level brand configuration
to the global config directory for reuse across projects.
}
\examples{
\dontrun{
write_brand()
}

}
\seealso{
\code{\link{save_brand}}, \code{\link{write_variables}},
  \code{\link{init}}
}
