% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_variables.R
\name{write_variables}
\alias{write_variables}
\title{Write Variables YAML for Quarto Projects}
\usage{
write_variables(path = here::here())
}
\arguments{
\item{path}{Character. Path to the project directory. Default is current project
root via \code{\link[here]{here}}.}
}
\value{
Invisibly returns the path to the file.
}
\description{
Creates or opens a \code{_variables.yml} file in a Quarto project for editing.
If the file already exists, it is opened directly. If global froggeR settings
exist, those are used as the starting point. Otherwise, the template is
downloaded from the
\href{https://github.com/kyleGrealis/frogger-templates}{frogger-templates}
repository.
}
\details{
The \code{_variables.yml} file stores reusable author metadata that Quarto
documents can reference. Available fields:

\itemize{
  \item \code{name}: Your full name as it appears in publications
  \item \code{email}: Contact email address
  \item \code{orcid}: ORCID identifier (e.g., 0000-0001-2345-6789)
  \item \code{url}: Personal website or profile URL
  \item \code{github}: GitHub username
  \item \code{affiliations}: Institution, department, etc.
}

Use \code{\link{save_variables}} to persist your project-level metadata to
the global config directory for reuse across projects.
}
\examples{
\dontrun{
write_variables()
}

}
\seealso{
\code{\link{save_variables}}, \code{\link{write_brand}},
  \code{\link{init}}
}
