% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\name{get_r_files}
\alias{get_r_files}
\title{Get all R files from a directory}
\usage{
get_r_files(directory, recursive = FALSE, pattern = "\\\\.R$")
}
\arguments{
\item{directory}{Character string. Path to directory containing R files.}

\item{recursive}{Logical. If \code{TRUE}, search subdirectories recursively.
Default is \code{FALSE}.}

\item{pattern}{Character string. Regular expression pattern for filenames.
Default is \code{"\\\\.R$"} (files ending in .R, case insensitive).}
}
\value{
Character vector of full paths to R files found in the directory.
Returns an empty vector with a warning if no files are found.
}
\description{
Recursively or non-recursively searches a directory for R source files
matching a specified pattern. Returns full paths suitable for use with
\code{\link{analyze_internal_dependencies_multi}}.
}
\examples{
# Create a temporary directory with R files
temp_dir <- tempfile()
dir.create(temp_dir)

# Create some R files
writeLines("f1 <- function(x) { x + 1 }", file.path(temp_dir, "file1.R"))
writeLines("f2 <- function(y) { y * 2 }", file.path(temp_dir, "file2.R"))

# Get all R files in the directory
files <- get_r_files(temp_dir)
print(files)

# Create subdirectory
subdir <- file.path(temp_dir, "subdir")
dir.create(subdir)
writeLines("f3 <- function(z) { z - 1 }", file.path(subdir, "file3.R"))

# Search recursively
files_recursive <- get_r_files(temp_dir, recursive = TRUE)
print(files_recursive)

# Clean up
unlink(temp_dir, recursive = TRUE)
}
